clear();
clc();
close all;                                  %Plots schließen

%KONFIGURATION---------------------------------------------------------------------
Y                   = @(x)   (-10*(x.^2))-(200*x)-(2000)+(1722.5*exp(0.05*((2*x)+3)));
dYdX                = @(x,y) (x.^2)+(0.1*y);
Anfangswert         = 0;                    %Anfangswert y0
obereGrenze         = 1.5;                  %Intervall obere Grenze
untereGrenze        = -1.5;                 %Intervall untere Grenze
Quantisierung       = 5;                    %Zerlegung des Intervals in Steigungsnäherungen
Korrektorschritte(:)= [1,3];
sKommastellenDouble = '%.8f';               %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%INITIALISIERUNG-------------------------------------------------------------------
X_INTERVALLSTUFEN(:)=untereGrenze:(obereGrenze-untereGrenze)/Quantisierung:obereGrenze;
AnzahlKorrektorschrittVarianten=size(Korrektorschritte,2);
aWERTETABELLE(1,1)="i";
aWERTETABELLE(1,2)="Xi";
for(i=1:1:AnzahlKorrektorschrittVarianten)
    aWERTETABELLE(1,i+2)=strcat("Y mit Korrektorschritte = ",num2str(Korrektorschritte(i)));
end
aWERTETABELLE(1,size(aWERTETABELLE,2)+1)="Y analytisch";
for(i=1:1:AnzahlKorrektorschrittVarianten)
    aWERTETABELLE(1,size(aWERTETABELLE,2)+1)=strcat("absoluter Fehler Korrektorschritt ",num2str(Korrektorschritte(i)));
end

%BERECHNUNG------------------------------------------------------------------------
for(i=0:1:Quantisierung)
    aWERTETABELLE(i+2,1)=num2str(i);
    aWERTETABELLE(i+2,2)=X_INTERVALLSTUFEN(i+1);
end
for(i=1:1:AnzahlKorrektorschrittVarianten)
    Speicher=funktion_heun_verfahren(dYdX,Anfangswert,obereGrenze,untereGrenze,Quantisierung,Korrektorschritte(i),sKommastellenDouble);
    for(j=1:1:size(Speicher,1))
        aWERTETABELLE(j+1,i+2)=num2str(Speicher(j),sKommastellenDouble);
    end
end
for(i=0:1:Quantisierung)
    aWERTETABELLE(i+2,AnzahlKorrektorschrittVarianten+2+1)=num2str(Y(X_INTERVALLSTUFEN(i+1)),sKommastellenDouble);
end
for(i=1:1:AnzahlKorrektorschrittVarianten)
    for(j=0:1:Quantisierung)
        aWERTETABELLE(j+2,AnzahlKorrektorschrittVarianten+2+1+i)=num2str(abs( ...
                                                                               str2double(aWERTETABELLE(j+2,2+i))-str2double(aWERTETABELLE(j+2,3+AnzahlKorrektorschrittVarianten)) ...
                                                                            ),sKommastellenDouble);
    end
end

%FUNKTIONSPLOT---------------------------------------------------------------------
xACHSE              = @(x) 0*x;
X(:)=X_INTERVALLSTUFEN(:);
FARBEN(:)=["black","blue","red","green","yellow","cyan","magenta"];
Y_POSITIONIERUNG=(max(str2double(aWERTETABELLE(2:end,AnzahlKorrektorschrittVarianten+3+i)))-min(str2double(aWERTETABELLE(2:end,AnzahlKorrektorschrittVarianten+3+i))))/AnzahlKorrektorschrittVarianten;
for(i=1:1:AnzahlKorrektorschrittVarianten)
    plot(X,str2double(aWERTETABELLE(2:end,AnzahlKorrektorschrittVarianten+3+i)),'color',char(FARBEN(mod(i,size(FARBEN,2))+1)));
    text(((obereGrenze-untereGrenze)/2)+untereGrenze,min(str2double(aWERTETABELLE(2:end,AnzahlKorrektorschrittVarianten+3+i)))+(i*Y_POSITIONIERUNG),cellstr(strcat("Korrektorschritt ",num2str(Korrektorschritte(i)))),'color',char(FARBEN(mod(i,size(FARBEN,2))+1)));
    hold on;
end
plot(X,xACHSE(X),'color','black');
hold on;                                											%Warten bis zur Plotausgabe
xlabel('x');
ylabel('Absoluter Fehler');
grid on;
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE                  									%Workspace aufräumen